<?php
/************************************************************************/
/* Module Avatar - NPDS                                                 */
/* Fichier de langue : Français (référence)                            */
/************************************************************************/
function Avatar_translate($phrase) {
    switch ($phrase) {

        // Titre & navigation
        case 'TITRE'              : $tmp = 'Gestion des Avatars'; break;
        case 'ONGLET_COMMUNS'     : $tmp = 'Avatars communs'; break;
        case 'ONGLET_USERS'       : $tmp = 'Avatars utilisateurs'; break;
        case 'ONGLET_TOUS'        : $tmp = 'Tout voir'; break;

        // Upload
        case 'UPLOAD_TITRE'       : $tmp = 'Envoyer des avatars communs'; break;
        case 'UPLOAD_BTN'         : $tmp = 'Envoyer'; break;
        case 'UPLOAD_HINT'        : $tmp = 'JPG, PNG, GIF, WEBP — Max 200 Ko'; break;
        case 'UPLOAD_OK'          : $tmp = 'avatar(s) envoyé(s).'; break;

        // Toolbar
        case 'BTN_SEL_ALL'        : $tmp = 'Tout sélectionner'; break;
        case 'BTN_DESEL'          : $tmp = 'Désélectionner'; break;
        case 'BTN_DEL_SEL'        : $tmp = 'Supprimer sélection'; break;
        case 'BTN_EXPORT_ZIP'     : $tmp = 'Export ZIP'; break;
        case 'BTN_DEL_ALL'        : $tmp = 'Tout supprimer'; break;
        case 'LABEL_COUNT_COMMON' : $tmp = 'avatar(s) commun(s)'; break;
        case 'LABEL_COUNT_USER'   : $tmp = 'avatar(s) utilisateur(s)'; break;

        // Cartes avatar
        case 'UTILISE'            : $tmp = 'Utilisé'; break;
        case 'BTN_SUPPRIMER'      : $tmp = 'Supprimer'; break;
        case 'BADGE_SITE'         : $tmp = 'site'; break;
        case 'BADGE_USER'         : $tmp = 'user'; break;

        // Confirmations JS
        case 'CONFIRM_DEL_ONE'    : $tmp = 'Supprimer cet avatar ?'; break;
        case 'CONFIRM_DEL_SEL'    : $tmp = 'Supprimer les avatars sélectionnés ?'; break;
        case 'CONFIRM_DEL_ALL_C'  : $tmp = 'Supprimer TOUS les avatars communs ? Cette action est irréversible !'; break;
        case 'CONFIRM_DEL_ALL_U'  : $tmp = 'Supprimer TOUS les avatars des utilisateurs ? Cette action est irréversible !'; break;
        case 'ALERT_NONE_SEL'     : $tmp = 'Aucun avatar sélectionné.'; break;

        // Messages retour
        case 'MSG_DEL_OK'         : $tmp = 'Avatar supprimé avec succès.'; break;
        case 'MSG_DEL_N_OK'       : $tmp = 'avatar(s) supprimé(s).'; break;
        case 'MSG_NO_ZIP'         : $tmp = 'ZipArchive non disponible sur ce serveur.'; break;
        case 'MSG_EXT_ERR'        : $tmp = 'extension non autorisée.'; break;
        case 'MSG_SIZE_ERR'       : $tmp = 'fichier trop lourd (max 200 Ko).'; break;
        case 'MSG_IMG_ERR'        : $tmp = 'fichier invalide.'; break;

        // Vide
        case 'EMPTY_COMMON'       : $tmp = 'Aucun avatar dans le dossier images/forum/avatar/'; break;
        case 'EMPTY_PRIVATE'      : $tmp = 'Aucun avatar uploadé trouvé pour les utilisateurs'; break;

        default: $tmp = "Translation error [** $phrase **]"; break;
    }
    return htmlentities($tmp, ENT_QUOTES|ENT_SUBSTITUTE|ENT_HTML401, 'UTF-8');
}
