<?php
/************************************************************************/
/* Module Avatar - NPDS                                                 */
/* Fichier de langue : English                                          */
/************************************************************************/
function Avatar_translate($phrase) {
    switch ($phrase) {

        // Title & navigation
        case 'TITRE'              : $tmp = 'Avatar Management'; break;
        case 'ONGLET_COMMUNS'     : $tmp = 'Common Avatars'; break;
        case 'ONGLET_USERS'       : $tmp = 'User Avatars'; break;
        case 'ONGLET_TOUS'        : $tmp = 'View All'; break;

        // Upload
        case 'UPLOAD_TITRE'       : $tmp = 'Upload Common Avatars'; break;
        case 'UPLOAD_BTN'         : $tmp = 'Upload'; break;
        case 'UPLOAD_HINT'        : $tmp = 'JPG, PNG, GIF, WEBP — Max 200 KB'; break;
        case 'UPLOAD_OK'          : $tmp = 'avatar(s) uploaded.'; break;

        // Toolbar
        case 'BTN_SEL_ALL'        : $tmp = 'Select All'; break;
        case 'BTN_DESEL'          : $tmp = 'Deselect'; break;
        case 'BTN_DEL_SEL'        : $tmp = 'Delete Selection'; break;
        case 'BTN_EXPORT_ZIP'     : $tmp = 'Export ZIP'; break;
        case 'BTN_DEL_ALL'        : $tmp = 'Delete All'; break;
        case 'LABEL_COUNT_COMMON' : $tmp = 'common avatar(s)'; break;
        case 'LABEL_COUNT_USER'   : $tmp = 'user avatar(s)'; break;

        // Avatar cards
        case 'UTILISE'            : $tmp = 'Used'; break;
        case 'BTN_SUPPRIMER'      : $tmp = 'Delete'; break;
        case 'BADGE_SITE'         : $tmp = 'site'; break;
        case 'BADGE_USER'         : $tmp = 'user'; break;

        // JS confirmations
        case 'CONFIRM_DEL_ONE'    : $tmp = 'Delete this avatar?'; break;
        case 'CONFIRM_DEL_SEL'    : $tmp = 'Delete selected avatars?'; break;
        case 'CONFIRM_DEL_ALL_C'  : $tmp = 'Delete ALL common avatars? This cannot be undone!'; break;
        case 'CONFIRM_DEL_ALL_U'  : $tmp = 'Delete ALL user avatars? This cannot be undone!'; break;
        case 'ALERT_NONE_SEL'     : $tmp = 'No avatar selected.'; break;

        // Feedback messages
        case 'MSG_DEL_OK'         : $tmp = 'Avatar successfully deleted.'; break;
        case 'MSG_DEL_N_OK'       : $tmp = 'avatar(s) deleted.'; break;
        case 'MSG_NO_ZIP'         : $tmp = 'ZipArchive is not available on this server.'; break;
        case 'MSG_EXT_ERR'        : $tmp = 'extension not allowed.'; break;
        case 'MSG_SIZE_ERR'       : $tmp = 'file too large (max 200 KB).'; break;
        case 'MSG_IMG_ERR'        : $tmp = 'invalid file.'; break;

        // Empty states
        case 'EMPTY_COMMON'       : $tmp = 'No avatar found in images/forum/avatar/'; break;
        case 'EMPTY_PRIVATE'      : $tmp = 'No uploaded avatar found for users'; break;

        default: $tmp = "Translation error [** $phrase **]"; break;
    }
    return htmlentities($tmp, ENT_QUOTES|ENT_SUBSTITUTE|ENT_HTML401, 'UTF-8');
}
