/* ================================================================
   Module Avatar - NPDS - Scripts admin
   ================================================================ */

function selAll(fid) {
    document.querySelectorAll('#' + fid + ' input[type=checkbox]').forEach(function(c) {
        c.checked = true;
        toggleCard(c);
    });
}

function deselAll(fid) {
    document.querySelectorAll('#' + fid + ' input[type=checkbox]').forEach(function(c) {
        c.checked = false;
        toggleCard(c);
    });
}

function toggleCard(cb) {
    cb.closest('.av-card').classList.toggle('selected', cb.checked);
}

function confirmSel(fid) {
    var n = document.querySelectorAll('#' + fid + ' input[type=checkbox]:checked').length;
    if (!n) {
        alert('Aucun avatar sélectionné.');
        return false;
    }
    return confirm('Supprimer ' + n + ' avatar(s) ?');
}

function openModal(src, cap) {
    document.getElementById('av-modal-img').src = src;
    document.getElementById('av-modal-caption').textContent = cap;
    document.getElementById('av-modal').classList.add('open');
}

function closeModal() {
    document.getElementById('av-modal').classList.remove('open');
}

document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') closeModal();
});
