<?php
/************************************************************************/
/* Module Avatar - NPDS                                                 */
/* Admin : modules/Avatar/admin/admin.php                              */
/*                                                                      */
/* Source 1 : images/forum/avatar/          => user_avatar = "foo.png" */
/* Source 2 : users_private/[u]/avatar.*    => user_avatar = "users_private/u/avatar.png" */
/************************************************************************/

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Cartouche sécurité NPDS
if (!strstr($_SERVER['PHP_SELF'], 'admin.php')) Access_Error();
if (strstr($ModPath,'..') || strstr($ModStart,'..') || stristr($ModPath,'script') || stristr($ModPath,'cookie') || stristr($ModPath,'iframe') || stristr($ModPath,'applet') || stristr($ModPath,'object') || stristr($ModPath,'meta') || stristr($ModStart,'script') || stristr($ModStart,'cookie') || stristr($ModStart,'iframe') || stristr($ModStart,'applet') || stristr($ModStart,'object') || stristr($ModStart,'meta'))
    die();

$f_meta_nom = 'Avatar';
admindroits($aid, $f_meta_nom);

// =====================================================================
// LANGUE
// __FILE__ = modules/Avatar/admin/admin.php => parent = modules/Avatar/
// =====================================================================
// inclusion fichier langue suivant language demandé par $language
if (file_exists('modules/'.$ModPath.'/lang/Avatar-'.$language.'.php'))
   include_once('modules/'.$ModPath.'/lang/Avatar-'.$language.'.php');
else
   include_once('modules/'.$ModPath.'/lang/Avatar-french.php');

// Alias court
function _t($k) { return Avatar_translate($k); }

// =====================================================================
// CONFIGURATION
// =====================================================================
$site_root    = realpath(dirname(__FILE__) . '/../../../') . '/';
$module_url   = $GLOBALS['nuke_url'] . '/modules/Avatar/';

$common_dir   = $site_root . 'images/forum/avatar/';
$common_url   = $GLOBALS['nuke_url'] . '/images/forum/avatar/';
$private_root = $site_root . 'users_private/';
$private_url  = $GLOBALS['nuke_url'] . '/users_private/';
$allowed_ext  = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
$max_size     = 200 * 1024;

$mod_url = 'admin.php?op=Extend-Admin-SubModule&ModPath=Avatar&ModStart=admin/admin';

// =====================================================================
// HELPERS DB
// =====================================================================

function av_get_common_avatars($dir, $url, $exts) {
    $list = [];
    if (!is_dir($dir)) return $list;
    foreach (glob($dir . '*') as $f) {
        $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
        if (in_array($ext, $exts) && is_file($f)) {
            $name        = basename($f);
            $list[$name] = [
                'file'  => $name,
                'path'  => $f,
                'url'   => $url . rawurlencode($name),
                'type'  => 'common',
                'uname' => null,
            ];
        }
    }
    ksort($list);
    return $list;
}

function av_get_private_avatars($site_root, $url, $exts) {
    global $NPDS_Prefix;
    $list = [];
    $res  = sql_query("SELECT uname, user_avatar FROM {$NPDS_Prefix}users
                       WHERE user_avatar LIKE 'users_private/%'
                       ORDER BY uname");
    if (!$res) return $list;
    while ($row = sql_fetch_array($res)) {
        $rel   = $row['user_avatar'];
        $uname = $row['uname'];
        $path  = $site_root . $rel;
        $ext   = strtolower(pathinfo($rel, PATHINFO_EXTENSION));
        if (!is_file($path) || !in_array($ext, $exts)) continue;
        $list[$rel] = [
            'file'  => basename($rel),
            'path'  => $path,
            'url'   => $url . substr($rel, strlen('users_private/')),
            'type'  => 'private',
            'uname' => $uname,
            'rel'   => $rel,
        ];
    }
    return $list;
}

function av_get_usage($keys) {
    global $NPDS_Prefix;
    $usage = [];
    foreach ($keys as $k) {
        $k_esc     = addslashes($k);
        $res       = sql_query("SELECT COUNT(*) as nb FROM {$NPDS_Prefix}users WHERE user_avatar = '{$k_esc}'");
        $row       = sql_fetch_array($res);
        $usage[$k] = (int)($row['nb'] ?? 0);
    }
    return $usage;
}

function av_file_info($path) {
    $fsize   = is_file($path) ? round(filesize($path) / 1024, 1) : 0;
    $imgsize = @getimagesize($path);
    $dims    = $imgsize ? $imgsize[0] . '×' . $imgsize[1] : '?';
    return ['size_kb' => $fsize, 'dims' => $dims];
}

// =====================================================================
// HELPERS RENDU
// =====================================================================

function av_msg($type, $msg) {
    return '<div class="av-msg av-' . $type . '">' . $msg . '</div>';
}

function av_card($key, $av, $nb_use, $mod_url, $tab) {
    $info      = av_file_info($av['path']);
    $is_common = ($av['type'] === 'common');
    $durl      = $mod_url . '&amp;action=delete&amp;file=' . urlencode($key) . '&amp;type=' . $av['type'] . '&amp;tab=' . $tab;
    $badge_cls = $is_common ? 'av-type-common' : 'av-type-private';
    $badge_lbl = _t($is_common ? 'BADGE_SITE' : 'BADGE_USER');
    $img_alt   = htmlspecialchars($is_common ? $key : $av['uname']);
    $img_cap   = addslashes($is_common ? $key : $av['uname']);
    $conf_del  = addslashes(_t('CONFIRM_DEL_ONE'));

    $html  = '<div class="av-card">';
    $html .= '<span class="av-type-badge ' . $badge_cls . '">' . $badge_lbl . '</span>';
    $html .= '<input type="checkbox" name="selected[]" value="' . $av['type'] . ':' . htmlspecialchars($key) . '" onchange="toggleCard(this)">';
    $html .= '<img src="' . $av['url'] . '" alt="' . $img_alt . '" loading="lazy"';
    $html .= ' onclick="openModal(\'' . $av['url'] . '\',\'' . $img_cap . '\')">';
    $html .= '<div class="av-card-info">';
    if ($is_common) {
        $html .= '<div class="fname" title="' . htmlspecialchars($key) . '">' . htmlspecialchars($key) . '</div>';
    } else {
        $html .= '<div class="funame">👤 ' . htmlspecialchars($av['uname']) . '</div>';
    }
    $html .= '<div class="fmeta">' . $info['size_kb'] . ' Ko · ' . $info['dims'] . '</div>';
    $html .= '<div>' . _t('UTILISE') . ' : <span class="av-badge ' . ($nb_use > 0 ? 'av-badge-used' : 'av-badge-free') . '">' . $nb_use . '</span></div>';
    $html .= '</div>';
    $html .= '<div class="av-card-actions">';
    $html .= '<a href="' . $durl . '" class="av-card-del" onclick="return confirm(\'' . $conf_del . '\')">🗑 ' . _t('BTN_SUPPRIMER') . '</a>';
    $html .= '</div>';
    $html .= '</div>';
    return $html;
}

function av_toolbar($form_id, $scope, $mod_url, $tab, $count, $label_icon, $label_count) {
    $conf_all = addslashes($scope === 'common' ? _t('CONFIRM_DEL_ALL_C') : _t('CONFIRM_DEL_ALL_U'));

    $html  = '<div class="av-toolbar">';
    $html .= '<button type="button" class="av-btn av-btn-gray" onclick="selAll(\'' . $form_id . '\')">☑ ' . _t('BTN_SEL_ALL') . '</button>';
    $html .= '<button type="button" class="av-btn av-btn-gray" onclick="deselAll(\'' . $form_id . '\')">☐ ' . _t('BTN_DESEL') . '</button>';
    $html .= '<button type="submit" class="av-btn av-btn-red" onclick="return confirmSel(\'' . $form_id . '\')">🗑 ' . _t('BTN_DEL_SEL') . '</button>';
    $html .= '<a href="' . $mod_url . '&amp;action=export_zip&amp;scope=' . $scope . '&amp;tab=' . $tab . '" class="av-btn av-btn-orange">📦 ' . _t('BTN_EXPORT_ZIP') . '</a>';
    $html .= '<button type="button" class="av-btn av-btn-red"';
    $html .= ' onclick="if(confirm(\'' . $conf_all . '\')){document.getElementById(\'allf-' . $scope . '\').submit()}">💥 ' . _t('BTN_DEL_ALL') . '</button>';
    $html .= '<span class="av-count">' . $label_icon . ' ' . $count . ' ' . $label_count . '</span>';
    $html .= '</div>';
    return $html;
}

// =====================================================================
// ACTIONS
// =====================================================================
$action   = isset($_POST['action']) ? $_POST['action'] : (isset($_GET['action']) ? $_GET['action'] : '');
$feedback = '';

// ---- Suppression unitaire
if ($action === 'delete' && isset($_GET['file'])) {
    $rel  = $_GET['file'];
    $type = $_GET['type'] ?? 'common';
    if ($type === 'common') {
        $path = $common_dir . basename($rel);
    } else {
        $abs  = realpath($private_root . str_replace('users_private/', '', $rel));
        $path = ($abs && strpos($abs, realpath($private_root)) === 0) ? $abs : '';
    }
    if ($path && is_file($path)) {
        unlink($path);
        $feedback = av_msg('success', '✔ ' . _t('MSG_DEL_OK') . ' <strong>' . htmlspecialchars(basename($rel)) . '</strong>');
    }
}

// ---- Suppression multiple
if ($action === 'delete_selected' && !empty($_POST['selected'])) {
    $deleted = 0;
    foreach ($_POST['selected'] as $entry) {
        [$stype, $srel] = explode(':', $entry, 2);
        if ($stype === 'common') {
            $path = $common_dir . basename($srel);
        } else {
            $abs  = realpath($private_root . str_replace('users_private/', '', $srel));
            $path = ($abs && strpos($abs, realpath($private_root)) === 0) ? $abs : '';
        }
        if ($path && is_file($path) && unlink($path)) $deleted++;
    }
    $feedback = av_msg('success', '✔ ' . $deleted . ' ' . _t('MSG_DEL_N_OK'));
}

// ---- Tout supprimer
if ($action === 'delete_all') {
    $scope   = $_POST['scope'] ?? 'common';
    $deleted = 0;
    if (in_array($scope, ['common', 'all'])) {
        foreach (glob($common_dir . '*') as $f) {
            $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
            if (in_array($ext, $allowed_ext) && is_file($f) && unlink($f)) $deleted++;
        }
    }
    if (in_array($scope, ['private', 'all'])) {
        $user_dirs = glob($private_root . '*', GLOB_ONLYDIR);
        if ($user_dirs) {
            foreach ($user_dirs as $udir) {
                foreach (glob($udir . '/avatar.*') as $f) {
                    $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
                    if (in_array($ext, $allowed_ext) && is_file($f) && unlink($f)) $deleted++;
                }
            }
        }
    }
    $feedback = av_msg('success', '✔ ' . $deleted . ' ' . _t('MSG_DEL_N_OK'));
}

// ---- Upload
if ($action === 'upload' && isset($_FILES['avatars'])) {
    $uploaded = 0;
    $errors   = [];
    $files    = $_FILES['avatars'];
    $count    = is_array($files['name']) ? count($files['name']) : 1;
    for ($i = 0; $i < $count; $i++) {
        $name  = is_array($files['name'])     ? $files['name'][$i]     : $files['name'];
        $tmp   = is_array($files['tmp_name']) ? $files['tmp_name'][$i] : $files['tmp_name'];
        $size  = is_array($files['size'])     ? $files['size'][$i]     : $files['size'];
        $error = is_array($files['error'])    ? $files['error'][$i]    : $files['error'];
        if ($error !== UPLOAD_ERR_OK) continue;
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        if (!in_array($ext, $allowed_ext)) { $errors[] = htmlspecialchars($name) . ' : ' . _t('MSG_EXT_ERR'); continue; }
        if ($size > $max_size)             { $errors[] = htmlspecialchars($name) . ' : ' . _t('MSG_SIZE_ERR'); continue; }
        if (!@getimagesize($tmp))          { $errors[] = htmlspecialchars($name) . ' : ' . _t('MSG_IMG_ERR');  continue; }
        if (move_uploaded_file($tmp, $common_dir . basename($name))) $uploaded++;
    }
    $msg      = $uploaded ? '✔ ' . $uploaded . ' ' . _t('UPLOAD_OK') : '';
    $err      = $errors   ? '<br>⚠ ' . implode('<br>⚠ ', $errors) : '';
    $feedback = av_msg($errors ? 'warn' : 'success', $msg . $err);
}

// ---- Export ZIP
if ($action === 'export_zip') {
    $scope = $_GET['scope'] ?? 'all';
    if (!class_exists('ZipArchive')) {
        $feedback = av_msg('error', '✘ ' . _t('MSG_NO_ZIP'));
    } else {
        $zip_path = sys_get_temp_dir() . '/avatars_export_' . time() . '.zip';
        $zip      = new ZipArchive();
        if ($zip->open($zip_path, ZipArchive::CREATE) === true) {
            if (in_array($scope, ['common', 'all'])) {
                foreach (glob($common_dir . '*') as $f) {
                    $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
                    if (in_array($ext, $allowed_ext) && is_file($f))
                        $zip->addFile($f, 'communs/' . basename($f));
                }
            }
            if (in_array($scope, ['private', 'all'])) {
                $user_dirs = glob($private_root . '*', GLOB_ONLYDIR);
                if ($user_dirs) {
                    foreach ($user_dirs as $udir) {
                        foreach (glob($udir . '/avatar.*') as $f) {
                            $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
                            if (in_array($ext, $allowed_ext) && is_file($f))
                                $zip->addFile($f, 'prives/' . basename(dirname($f)) . '_' . basename($f));
                        }
                    }
                }
            }
            $zip->close();
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename="avatars_export_' . $scope . '.zip"');
            header('Content-Length: ' . filesize($zip_path));
            header('Pragma: no-cache');
            readfile($zip_path);
            unlink($zip_path);
            exit;
        }
    }
}

// =====================================================================
// COLLECTE DES DONNÉES
// =====================================================================
$common_avatars  = av_get_common_avatars($common_dir, $common_url, $allowed_ext);
$private_avatars = av_get_private_avatars($site_root, $private_url, $allowed_ext);

$usage_keys = array_merge(array_keys($common_avatars), array_keys($private_avatars));
$usage      = av_get_usage($usage_keys);

$total_common  = count($common_avatars);
$total_private = count($private_avatars);
$total         = $total_common + $total_private;

$tab = isset($_GET['tab']) ? $_GET['tab'] : 'common';

// Chaînes JS passées en data-attribute pour éviter les conflits d'encodage
$js_strings = [
    'alert_none_sel'   => _t('ALERT_NONE_SEL'),
    'confirm_del_sel'  => _t('CONFIRM_DEL_SEL'),
];

// =====================================================================
// RENDU HTML
// =====================================================================

// CSS + JS
echo '<link rel="stylesheet" type="text/css" href="' . $module_url . 'style/avatar.css">';
// Passage des chaînes traduites au JS via variable globale
echo '<script type="text/javascript">';
echo 'var AV_LANG = ' . json_encode($js_strings, JSON_UNESCAPED_UNICODE) . ';';
echo '</script>';
echo '<script type="text/javascript" src="' . $module_url . 'js/avatar.js"></script>';

echo '<div class="av-wrap">';
echo '<div class="av-title">🖼 ' . _t('TITRE') . '</div>';

if ($feedback) echo $feedback;

// Onglets
echo '<div class="av-tabs">';
$tabs = [
    'common'  => [_t('ONGLET_COMMUNS'), $total_common],
    'private' => [_t('ONGLET_USERS'),   $total_private],
    'all'     => [_t('ONGLET_TOUS'),    $total],
];
foreach ($tabs as $t => [$label, $cnt]) {
    $active = ($tab === $t) ? ' active' : '';
    echo '<a class="av-tab' . $active . '" href="' . $mod_url . '&amp;tab=' . $t . '">';
    echo $label . ' <small>(' . $cnt . ')</small></a>';
}
echo '</div>';

// =====================================================================
// PANNEAU COMMUNS
// =====================================================================
echo '<div class="av-tab-panel' . (in_array($tab, ['common', 'all']) ? ' active' : '') . '">';

if ($tab === 'common') {
    echo '<div class="av-upload-box">';
    echo '<h3>📤 ' . _t('UPLOAD_TITRE') . '</h3>';
    echo '<form method="post" action="' . $mod_url . '&amp;tab=common" enctype="multipart/form-data">';
    echo '<input type="hidden" name="action" value="upload">';
    echo '<div class="av-upload-row">';
    echo '<input type="file" name="avatars[]" accept="image/*" multiple required>';
    echo '<button type="submit" class="av-btn av-btn-green">⬆ ' . _t('UPLOAD_BTN') . '</button>';
    echo '</div>';
    echo '<small style="color:#999">' . _t('UPLOAD_HINT') . ' → <code>images/forum/avatar/</code></small>';
    echo '</form>';
    echo '</div>';
}

echo '<form method="post" action="' . $mod_url . '&amp;tab=' . $tab . '" id="form-common">';
echo '<input type="hidden" name="action" value="delete_selected">';
echo av_toolbar('form-common', 'common', $mod_url, $tab, $total_common, '📁', _t('LABEL_COUNT_COMMON'));

if ($total_common === 0) {
    echo '<div class="av-empty">' . _t('EMPTY_COMMON') . '</div>';
} else {
    echo '<div class="av-grid">';
    foreach ($common_avatars as $key => $av) {
        echo av_card($key, $av, $usage[$key] ?? 0, $mod_url, $tab);
    }
    echo '</div>';
}
echo '</form>';
echo '</div>';

// =====================================================================
// PANNEAU PRIVÉS
// =====================================================================
echo '<div class="av-tab-panel' . (in_array($tab, ['private', 'all']) ? ' active' : '') . '">';
echo '<form method="post" action="' . $mod_url . '&amp;tab=' . $tab . '" id="form-private">';
echo '<input type="hidden" name="action" value="delete_selected">';
echo av_toolbar('form-private', 'private', $mod_url, $tab, $total_private, '👤', _t('LABEL_COUNT_USER'));

if ($total_private === 0) {
    echo '<div class="av-empty">' . _t('EMPTY_PRIVATE') . '</div>';
} else {
    echo '<div class="av-grid">';
    foreach ($private_avatars as $key => $av) {
        echo av_card($key, $av, $usage[$key] ?? 0, $mod_url, $tab);
    }
    echo '</div>';
}
echo '</form>';
echo '</div>';

// Formulaires cachés "tout supprimer"
echo '<form id="allf-common" method="post" action="' . $mod_url . '&amp;tab=' . $tab . '" style="display:none">';
echo '<input type="hidden" name="action" value="delete_all">';
echo '<input type="hidden" name="scope" value="common"></form>';

echo '<form id="allf-private" method="post" action="' . $mod_url . '&amp;tab=' . $tab . '" style="display:none">';
echo '<input type="hidden" name="action" value="delete_all">';
echo '<input type="hidden" name="scope" value="private"></form>';

// Modal
echo '<div id="av-modal" onclick="closeModal()">';
echo '<span id="av-modal-close">✕</span>';
echo '<img id="av-modal-img" src="" alt="">';
echo '<div id="av-modal-caption"></div>';
echo '</div>';

echo '</div>'; // /av-wrap


adminfoot('','','','');
?>
